# Rmap
# Copyright 2008 by Brian C. Christensen

# 080609 - start first draft
# 080613 - first working version
# 080617 - clear 'in use' flag for columns in unneeded tables
# 080802 - generate better table names from fact type readings
# 081116 - add relational diagram update
# 081124 - generate indices

import ORM
##import math

lowerCaseColumnNames = True

debug = 1

# the rule for getting a name from an object type is a bit complicated
def GetNameFromObjectType(objecttype):
    name = None
    if objecttype.RefMode:
        refmode = objecttype.RefMode
        if refmode.startswith('.'):
            name = objecttype.Name + refmode[1:]
        elif ':' not in refmode:
            name = objecttype.RefMode  # adj ref mode to col name
    if not name:
        name = objecttype.Name  # entity name
    if name and name[0].isupper() and not name.isupper() and lowerCaseColumnNames:
        name = name[0].lower() + name[1:]
    return name

def GetNameFromReading(factreading):
    roles = factreading.ORMRoleSequence.GetList('ORMRolePosition')
    roles.sort(cmp=lambda x,y: cmp(x.Seq, y.Seq))
    reading = (factreading.Reading or "").strip()  # leading/trailing spaces
    if len(roles) == 2 and '/' in reading:
        parts = reading.split('/')
        if len(parts) == 2:
            if parts[0] == '':  # only backwards reading provided
                reading = parts[1]
                roles = [ roles[1], roles[0] ]  # reverse order of roles
            else:  # use forward reading
                reading = parts[0]
    words = reading.split()
    if '...' not in words and len(roles) == 2:
        words.insert(0, roles[0].ORMRole.ORMObjectType.Name or "xx")
        words.append(roles[1].ORMRole.ORMObjectType.Name or "xx")
    blank = 0
    for i, word in enumerate(words):
        if word == '...':
            if blank < len(roles):
                r = roles[blank].ORMRole
                words[i] = ( r.Name
                    or GetNameFromObjectType(r.ORMObjectType ) or "xx")
            else:
                words[i] = "xx"
            blank += 1
        elif word[0].islower():
            words[i] = word[0].upper() + word[1:]
    return "".join(words)

def GetNameFromUnaryRole(role):
##    return GetNameFromReading(role.ORMFactType.ORMFactReading)
    name = role.Name
    if not name:
        name = role.ORMFactType.ORMFactReading.Reading or 'unary'
    words = name.split()
    for i, word in enumerate(words):
        if word[0].islower():
            words[i] = word[0].upper() + word[1:]
    return "".join(words)
    
def Rmap(project):
    table = {}  # tables

    def AddToTable(obj, obj_list):
        key = (obj.Table, obj.ID)
        print 'adding', key, obj_list
        if key not in table:
            if obj.Table == 'ORMObjectType':
                table[key] = [obj]
            else:
                table[key] = []
        table[key].extend(obj_list)

    # Create a table for each independent entity    
    objecttype_list = project.GetList('ORMObjectType')
    for objecttype in objecttype_list:
        if objecttype.Independent:
            AddToTable(objecttype, [])

    def NumFuncRoles(ot):
        if ot.Table == 'ORMRole':
            ot = ot.ORMObjectType
        return len([ role for role in ot.GetList('ORMRole')
                     if role.Unique or role.ORMFactType.Nary == 1 ])

    fact_list = project.GetList('ORMFactType')
    for fact in fact_list:
        # create a table for each m:m fact type
        if fact.Nary > 2 or (fact.Nary == 2 and fact.Unique):
            AddToTable(fact, fact.GetList('ORMRole'))
        # absorbe unaries into entity
        elif fact.Nary == 1:
            role = fact.GetList('ORMRole')[0]  # only one
            AddToTable(role.ORMObjectType, [role])
        elif fact.Nary == 2:
            role_pos = fact.ORMFactReading.ORMRoleSequence.GetList('ORMRolePosition')
            role_pos.sort(cmp=lambda x,y: cmp(x.Seq, y.Seq))  # order of preferred reading
            roles = [ x.ORMRole for x in role_pos ]
            print 'binary roles', fact.Nary, roles
            mapto = 'left'  # default
            # 1:m; m:1
            if roles[0].Unique in ('a','p') and roles[1].Unique not in ('a', 'p'):
                mapto = 'left'
            elif roles[1].Unique in ('a', 'p') and roles[0].Unique not in ('a', 'p'):
                mapto = 'right'
            # 1:1 - see IMRD p. 491
            elif NumFuncRoles(roles[0]) > 1 and NumFuncRoles(roles[1]) == 1:
                mapto = 'left'
            elif NumFuncRoles(roles[1]) > 1 and NumFuncRoles(roles[0]) == 1:
                mapto = 'right'
            elif NumFuncRoles(roles[0]) > 1 and NumFuncRoles(roles[1]) > 1:
                if roles[0].Mandatory == 'a' and roles[1].Mandatory != 'a':
                    mapto = 'left'
                elif roles[1].Mandatory == 'a' and roles[0].Mandatory != 'a':
                    mapto = 'right'
                else:
                    pass  # default
            elif NumFuncRoles(roles[0]) == 1 and NumFuncRoles(roles[1]) == 1:
                mapto = 'center'
            else:  # not possible 
                pass

            # do mapping (should allow user to override)
            if mapto == 'left':
                AddToTable(roles[0].ORMObjectType, [roles[1]])
            elif mapto == 'right':
                AddToTable(roles[1].ORMObjectType, [roles[0]])
            else:
                AddToTable(fact, roles)

    # IMRD p. 481: check clauses can be used implement value and
    # frequency constriats. Foreign keys can represent subset constraints
    # (this depends on whether any table is a must).

    # update table definitions to match rmap results
    def FindByTarget(obj_list, target):
        ''' find object in list that points to target'''
        for o in obj_list:
            if o.Target is target:
                return o
                break
        return None
    
    old_tables = project.GetList('RelationalTable')
    db = project.db
    for k, columns in table.iteritems():
        # find or create table
        target = db.GetObject(k[0], k[1])
        table = FindByTarget(old_tables, target)
        if table:
            old_tables.remove(table)  # leave only unneeded tables
        else:
            table = db.GetObject('RelationalTable')
            table.DateAdded = Data.TodayString()
            table.Project = project
            table.Target = target
        # follow rules to create new name for table
        name = ''
        if target.Table == 'ORMObjectType':
            name = target.Name  # object type name
        elif target.Table == 'ORMFactType':
            name = target.Name  # fact type name
            if not name:
                name = GetNameFromReading(target.ORMFactReading)  # prefered reading
        if not name:
            name = 'default'
        table.RmapName = name
        if table.OverrideName:
            table.Name = table.OverrideName  # hand coded name for table
        else:
            table.Name = table.RmapName  # hand coded name for table
        table.InUse = 'y'

        old_columns = table.GetList('RelationalColumn')
        for target in columns:
            column = FindByTarget(old_columns, target)
            if column:
                old_columns.remove(column)  # leave only unneeded columns
            else:
                column = db.GetObject('RelationalColumn')
                column.DateAdded = Data.TodayString()
                column.Project = project
                column.RelationalTable = table
                column.Target = target
            name = ''
            if target.Table == 'ORMObjectType':
                name = GetNameFromObjectType(target)  # object type name
            elif target.Table == 'ORMRole':
                name = target.Name  # role name
##                if not name:
##                    name = target.ORMFactType.ORMFactReading.Reading  # hyphen name
                if not name and target.ORMFactType.Nary == 1:
                    name = GetNameFromUnaryRole(target)
                if not name:
                    name = GetNameFromObjectType(target.ORMObjectType)
            if not name:
                name = 'default'
            column.RmapName = name
            column.Name = column.RmapName
            if column.OverrideName:  # hand coded column name
                column.Name = column.OverrideName

            ctype = None
            if target.Table == 'ORMObjectType':
                ctype = target.DataType
            elif target.Table == 'ORMRole':
                if target.ORMFactType.Nary == 1:  # unary
                    ctype = "boolean"
                else:
                    ctype = target.ORMObjectType.DataType
            if not ctype:
                ctype = 'varchar(20)'
            column.RmapDataType = ctype
            column.DataType = column.RmapDataType
            if column.OverrideDataType:
                column.DataType = column.OverrideDataType

            column.RmapKey = None  # left for all non-pk columns
            column.Key = None  # overriden later for pk

            column.RmapNotNull = None  # not set by rmap yet
            column.NotNull = column.RmapNotNull
            if column.OverrideNotNull:
                if column.OverrideNotNull == '-':
                    column.NotNull = None
                else:
                    column.NotNull = column.OverrideNotNull

            column.InUse = 'y'

        for old in old_columns:
            old.InUse = None
            if not old.InBase:
                old.Delete()

    def DeleteOld(delete_list, child_type):
        for old_table in delete_list:  # old tables that aren't needed
            old_columns = old_table.GetList(child_type)
            for old in old_columns:
                old.InUse = None  # none of the columns would be in use
                if not old.InBase:
                    old.Delete()
            old_table.InUse = None
            if not old_table.InBase:
                old_table.Delete()

    DeleteOld(old_tables, 'RelationalColumn')

    # create needed indexes        
    def MakeIndex(project, target):
        index = db.GetObject('RelationalIndex')
        index.DateAdded = Data.TodayString()
        index.Project = project
        index.Target = target
        return index

    old_index = project.GetList('RelationalIndex')
    new_index = []
    print '-----', old_index
    for fact in fact_list:
        if fact.Nary < 2: continue  # only w/ multi-column index
        if fact.Unique:
            index = FindByTarget(old_index, fact)
            if index:
                old_index.remove(index)
            else:
                index = MakeIndex(project, fact)
            new_index.append(index)
        roles = fact.GetList('ORMRole')
        for role in roles:  # only w/ Nary > 2
            if role.UniqueOther:
                index = FindByTarget(old_index, role)
                if index:
                    old_index.remove(index)
                else:
                    index = MakeIndex(project, role)
                print '-r', index
                new_index.append(index)
    for constraint in project.GetList('ORMConstraint'):
        if constraint.Operator != 'Preferred': continue
        index = FindByTarget(old_index, constraint)
        if index:
            old_index.remove(index)
        else:
            index = MakeIndex(project, constraint)
        new_index.append(index)
        
    DeleteOld(old_index, 'RelationalIndexColumn')

    # update index columns
    def MakeIndexColumn(project, target):
        ic = db.GetObject('RelationalIndexColumn')
        ic.DateAdded = Data.TodayString()
        ic.Project = project
        ic.Target = target
        return ic

    for index in new_index:
        index.RmapName = "RI" + str(index.ID)
        # all currently generated indices should be marked as unique
        index.RmapUnique = "unique"  # placed in sql as is
        
        index.Name = index.RmapName
        if index.OverrideName:
            index.Name = index.OverrideName

        index.Unique = index.RmapUnique
        if index.OverrideUnique:
            if index.OverrideUnique == '-':
                index.Unique = None
            else:
                index.Unique = index.OverrideUnique

        index.Key = index.RmapKey
        if index.OverrideKey:
            if index.OverrideKey == '-':
                index.Key = None
            else:
                index.Key = index.OverrideKey

        index.InUse = 'y'

        target = index.Target
        print "----->", target.Table
        if target.Table == 'ORMFactType':
            table = FindByTarget(project.GetList('RelationalTable'), target)
        elif target.Table == 'ORMRole':
            table = FindByTarget(project.GetList('RelationalTable'), target.ORMFactType)
        elif target.Table == 'ORMConstraint':
            ot = None
            seq = [ x for x in target.GetList('ORMRoleSequence') if x.Seq == 1 ]
            if seq:
                roles = [ x.ORMRole for x in
                          seq[0].GetList('ORMRolePosition') if x and x.ORMRole ]
                if roles:
                    fact = roles[0].ORMFactType
                    other_roles = [ x for x in fact.GetList('ORMRole') if not x == roles[0] ]
                    if other_roles:
                        ot = other_roles[0].ORMObjectType
            table = FindByTarget(project.GetList('RelationalTable'), ot)
        else:  # shouldn't happen
            table = None
        print "------>", table
        
        table_columns = table.GetList('RelationalColumn')
        if table:
            index.RelationalTable = table
        else:
            index.RelationalTableID = None

        old_columns = index.GetList('RelationalIndexColumn')
        target = index.Target
        if target.Table == 'ORMFactType':
            roles = target.GetList('ORMRole')
            roles.sort(cmp=lambda x,y: cmp(x.Seq, y.Seq))  # use order in facttype
        elif target.Table == 'ORMRole':
            roles = [ x for x in target.ORMFactType.GetList('ORMRole')
                      if not x == target ]
            roles.sort(cmp=lambda x,y: cmp(x.Seq, y.Seq))  # use order in facttype
        elif target.Table == 'ORMConstraint':
            seq = [ x for x in target.GetList('ORMRoleSequence') if x.Seq == 1 ]
            if seq:
                rolepos = seq[0].GetList('ORMRolePosition')
                rolepos.sort(cmp=lambda x,y: cmp(x.Seq, y.Seq))  # use order in role seq
                roles = [ x.ORMRole for x in rolepos if x.ORMRole ]
            else:
                roles = [ ]
        else:  # shouldn't happen
            roles = []

        seq = 1
        for role in roles:
            index_col = FindByTarget(old_columns, role)
            if index_col:
                old_columns.remove(index_col)
            else:
                index_col = MakeIndexColumn(project, role)
            index_col.RelationalIndex = index
            index_col.RelationalColumn = FindByTarget(table_columns, role)
            index_col.InUse = 'y'
            index_col.Seq = seq
            seq += 1

        for old in old_columns:
            old.InUse = None  # none of the columns would be in use
            if not old.InBase:
                old.Delete()

    # set up primary keys
    tablepk = {}
    tables = project.GetList('RelationalTable')
    for t in tables:
        # the pk for most tables consists of the non ORMRole columns
        pkeys = [ c for c in t.GetList('RelationalColumn')
                 if c.InUse and c.Target.Table != 'ORMRole' ]
        if len(pkeys) == 1:  # non m:m tables?
            tablepk[t.Target] = pkeys
            keycol = pkeys[0]
            keycol.RmapKey = 'primary key'
        else:  # handle multicolumn primary keys
            pass

    # set up the foreign keys
    for t in tables:
        for column in t.GetList('RelationalColumn'):
            if not column.InUse: continue
            source = column.Target
            if source.Table == 'ORMRole':
                column.RelationalReference = None
                if source.ORMFactType.Nary == 1: continue  # unary are never foreign keys
                key = source.ORMObjectType
                if key in tablepk:  # this MAY be a foreign key
                    column.RelationalReference = tablepk[key][0]  # good enough for now
            # also do column level primary key overrides
            column.Key = column.RmapKey
            if column.OverrideKey:
                if column.OverrideKey == "-":
                    column.Key = ''  # or None?
                else:
                    column.Key = column.OverrideKey

    # sort table columns
    def sorter(a, b):
        if a.Name == 'ID': return -1  # ID first
        if b.Name == 'ID': return 1
        if a.InUse and not b.InUse: return -1  # not InUse last
        if not a.InUse and b.InUse: return 1
        if a.Key and not b.Key: return -1  # primary key columns early
        if not a.Key and b.Key: return 1
        return cmp(a.Name, b.Name)
    for t in tables:
        columns = t.GetList('RelationalColumn')
        columns.sort(cmp=sorter)
        for i, c in enumerate(columns):
            c.Seq = i + 1

def RelationalDiagram(report):
    print 'starting to update:', report
    if report.Subtype == 'RelationalDiagram':  # should always be true
        table = 'RelationalTable'
        col = 'RelationalColumn'
    else:  # 'DWDiagram'
        table = 'StarTable'
        col = 'StarColumn'

    box = 'RelationalTableShape'
    line = 'RelationalConnectorShape'
    all_boxes = report.GetGraphicList('RelationalTableShape')
    all_lines = report.GetGraphicList('RelationalConnectorShape')
    all_tables = report.Project.GetList(table)
    all_references = [ x for x in report.Project.GetList(col)
                       if x.InUse and x.RelationalReference ]

    # this is just temporary, until all of the old test data has been converted
    all_old_name = report.GetGraphicList('RelationalTableConnectorShape')
    for old in all_old_name:
        print "deleting old connector type", old
        old.Delete()
    # end of temporary

    for shape in all_boxes:
        target = shape.Target
        if target in all_tables:
            all_tables.remove(target)
            # keep the object, just redraw it in case the columns have change
##            shape.canvas.RedrawID(shape.dcid)
        elif target:
            # delete the graphic object
            shape.Delete()
        else:
            print 'target was false'

    x, y = 100, 100
    for target in all_tables:  # add graphics for tables w/o graphics
        shape = Data.DBObject.GetObject('GraphicObject', subtype=box)
        shape.ProjectID = report.ProjectID
        shape.ReportID = report.ID
        shape.DateAdded = Data.TodayString()
        shape.Target = target
        shape.PosX, shape.PosY = x, y
        x += 100
        if x > 800:
            x = 100
            y += 100
##            shape.canvas.RedrawID(shape.dcid)        

    all_boxes = report.GetGraphicList('RelationalTableShape')
    def findBoxByTarget(target):
        for x in all_boxes:
            if x.Target == target:
                return x
        return None

    for shape in all_lines:
        target = shape.Target
        if target in all_references:
            all_references.remove(target)
            # make sure that it has the correct Nodes (needs better edits?)
            shape.NodeA = findBoxByTarget(target.RelationalReference.RelationalTable)
            shape.NodeB = findBoxByTarget(target.RelationalTable)
        elif target:
            # delete the graphic object
            shape.Delete()
        else:
            print 'target was false'

    x, y = 100, 100
    for target in all_references:  # add graphics for foreign keys w/o graphics
        if target.RelationalReference:
            nodeA = findBoxByTarget(target.RelationalReference.RelationalTable)
        else:
            nodeA = None
        nodeB = findBoxByTarget(target.RelationalTable)
        if nodeA and nodeB:
            shape = Data.DBObject.GetObject('GraphicObject', subtype=line)
            shape.ProjectID = report.ProjectID
            shape.ReportID = report.ID
            shape.DateAdded = Data.TodayString()
            shape.Target = target
            shape.PosX, shape.PosY = x, y
            x += 100
            if x > 800:
                x = 100
                y += 100
            shape.CommitPos()
            shape.NodeA = nodeA
            shape.NodeB = nodeB

def UpdateRelationalDiagram(project):
    db = Data.DBObject  # will get objects from this database

    reports = [ x for x in project.GetList('Report') if x.Subtype == 'RelationalDiagram' ]
    print 'qualifying reports', reports

    if not reports:
        print 'adding new relational diagram'
        report_def = {
            'Name': 'Relational Diagram',
            'Subtype': 'RelationalDiagram',
            'ReportTypeID': 'ORM Diagram',  # be sure to spell this right
            'Lock': 'Move',  # allow objects to be moved, not otherwise changed
            }
        rid = Data.AddReport(project.ID, report_def)  # should return id of new report?
        print 'added report w/ id', rid
        if rid:
            report = db.GetObject('Report',rid)
            reports.append(report)
            print 'added', report
        else:
            print 'failed to add report'

    for report in reports:  # update and refresh relational table reports
        if report.Open: ReportAids.CloseReport(report.ID)
        RelationalDiagram(report)
        if not report.Open: ReportAids.OpenReport(report.ID)

def Do(self):
    rid = self.ReportID  # current report
    if rid == 1 :
        Data.Hint('Not for use in main report')
        return  # do nothing

    db = Data.DBObject  # will get objects from this database
    report = db.GetObject('Report',rid)

    Data.AddAlias('RelationalReference', 'RelationalColumn')  # not in old install script
    Data.AddTable('RelationalIndex')  # ditto
    Data.AddTable('RelationalIndexColumn')  # ditto

    Rmap( report.Project )
    UpdateRelationalDiagram( report.Project )

    Data.SetUndo('Rmap')

Do(self)
